# README

This repository contains the implementation code for the paper **"Beyond Average Value Function in Precision Medicine: Maximum Probability-Driven Reinforcement Learning for Survival Analysis"**. The code directly corresponds to the content of the paper, enabling readers to reproduce the proposed methodology, theoretical results, simulation experiments, and real-world data analysis.

---

## Directory Structure

```
.
├── Environment/         # Environment for program execution
├── Simulation/          # Simulation experiments for Section 5 of the paper and the appendices (Python)
├── Real Data Analysis/  # Code for Section 6 of the paper (Python)
├── draw/                # Image plotting program (MATLAB)
```

---

## Running Environment
The code for the paper's running environment is stored in the **`Environment/`** folder. Specifically:
- The simulation experiments (i.e., Settings 1 and 2 in Section 5, along with Supplementary Experiments A.4 and A.8) are run using the **`drlagent`** environment.
- Appendix A.5 and Chapter 6 (Real Data Analysis) are run using the **`rl`** environment.

Notably, the current **`lifelines`** package does not include a survival function estimation function for the Aah model. We have supplemented this part, so please replace the **`aalen_additive_fitter.py`** file with the file we provided.  

## Simulation
All code for the paper's simulation experiments is stored in the **`Simulation/`** folder, where:
- **`Simulation/Setting 1/`**
  - `env1.py`: Simulation environment for Setting 1 (discrete action space).
  - `simulation1.py`: Main execution function. After running, results are saved in the folder named `results_(model)_seed_(seed)`.
- **`Simulation/Setting 2/`**
  - `env2.py`: Simulation environment for Setting 2 (continuous action space).
  - `simulation2.py`: Main execution function. After running, results are saved in the folder named `results_(model)_seed_(seed)`.
- **`Simulation/Alpha/`**
  - `alpha_training.py`: Program code for Appendix A.4 (i.e., $\alpha_k$ selection). After running, results are saved in the folder named `results_(model)_seed_(seed)`.
- **`Simulation/Epicare/`**
  - `dqn_utils.py`: Contains functions for the DQN (Deep Q-Network) algorithm in reinforcement learning.
  - `epicare.py`: Main environment function for Epicare.
  - `Gen_data.py`: Function for generating datasets.
  - `survival_train.ipynb`: Training code for the AaH, Cox, and KM models in the paper.
  - `RL_train.ipynb`: Training code for the RL (Reinforcement Learning) model in the paper.
- **`Simulation/Supplementary Experiment/`**
  - `stage_env.py`: Program environment for the multi-stage scenario in Supplementary Experiment A.8 (Appendix A.8).
  - `supp1_main.py`: Main execution code. After running, results are saved in the directory named `results_(model)_seed_(seed)_stage_(stage)`.

## Real Data Analysis
All training code for the paper's real-world data analysis is stored in **`Real Data Analysis/`**, where:
- **`data_process_1.py`** and **`data_process_2.py`**: Data processing and generation codes (to be executed in sequence).
- **`data_process_3_train_Cox.ipynb`**: Reinforcement learning training code for the Cox model.
- **`data_process_3_train_Aah.ipynb`**: Reinforcement learning training code for the AaH model.
- **`data_process_3_train_t.ipynb`**: Reinforcement learning training code using the objective function of Liu et al.’s baseline model.
- **`draw_lines/`**: Code for drawing images.

## Draw
For the plotting code, note that the data must be organized into the format `results_(model)/results_(model)_seed_(seed)_stage_(stage)` first, and then MATLAB code is used for plotting.

---
## Run Examples
1. Run simulation (Setting 1: Linear + Discrete)
```bash
python Simulation/Setting 1/simulation1.py
```
2. Run simulation (Setting 2: Nonlinear + Continuous)
```bash
python Simulation/Setting 2/simulation2.py
```